/*
 * Copyright (c) 1999-2001 Lutris Technologies, Inc. All Rights
 * Reserved.
 * 
 * This source code file is distributed by Lutris Technologies, Inc. for
 * use only by licensed users of product(s) that include this source
 * file. Use of this source file or the software that uses it is covered
 * by the terms and conditions of the Lutris Enhydra Development License
 * Agreement included with this product.
 * 
 * This Software is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
 * ANY KIND, either express or implied. See the License for the specific terms
 * governing rights and limitations under the License.
 * 
 * Contributor(s):
 * 
 * $Id: EndTag.java,v 1.1.1.1 2001/01/05 05:11:17 sese0235 Exp $
 */

package de.kxml.parser;

import de.kxml.*;

/**
 * A class for events indicating the
 * end of an element
 */
public class EndTag extends ParseEvent {
    StartTag startTag;

    /**
     * Constructor declaration
     *
     *
     * @param start
     *
     * @see
     */
    public EndTag(StartTag start) {
	startTag = start;
    }

    /**
     * returns the name of the element
     */
    public String getName() {
	return startTag.name;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String getNamespace() {
	return startTag.namespace;
    } 

    /**
     * returns the integer constant assigned to this event type
     * (DocumentEvent.END_ELEMENT).
     */
    public int getType() {
	return Xml.END_TAG;
    } 

    /**
     * Method declaration
     *
     *
     * @param start
     *
     * @return
     *
     * @see
     */
    public boolean endCheck(StartTag start) {
	if (start != null && startTag != start) {
	    throw new RuntimeException("end tag mismatch");
	} 

	return true;
    } 

    /**
     * Method declaration
     *
     *
     * @return
     *
     * @see
     */
    public String toString() {
	return "</" + startTag.name + ">";
    } 

}

